% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_DocumentationDesc.R
\name{get_layer_dict}
\alias{get_layer_dict}
\title{Dictionary of layers}
\usage{
get_layer_dict(layer)
}
\arguments{
\item{layer}{\code{string} Name of the layer that should be returned. If \code{layer="all"}
all layers are returned as a \code{list}.}
}
\value{
Returns a \code{list} with the following entries:
\itemize{
\item title: \code{string} Name of the layer.
\item desc: \code{string}Description of the layer written in rmarkdown.
\item img: \code{string} Name of the image used to illustrate the layer. File extension must be '.png'.
\item references: \code{vector} of \code{strings}. Every entry contains the literature reference in rmarkdown if relevant.
\item param_prefix: \code{string} Prefix used for all parameters to configure the specific layer.
}
}
\description{
Function for receiving a \code{list} containing a description of all layers
user of the package can apply.
}
\seealso{
Other Utils Documentation: 
\code{\link{build_documentation_for_model}()},
\code{\link{build_layer_stack_documentation_for_vignette}()},
\code{\link{get_desc_for_core_model_architecture}()},
\code{\link{get_dict_cls_type}()},
\code{\link{get_dict_core_models}()},
\code{\link{get_dict_input_types}()},
\code{\link{get_layer_documentation}()},
\code{\link{get_parameter_documentation}()}
}
\concept{Utils Documentation}
\keyword{internal}
