% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.hue.R
\name{stability.hue}
\alias{stability.hue}
\title{Nonparametric stability analysis}
\usage{
stability.hue(dataf, res_var, gen_var, env_var, rep_var, alpha = 0.05,
  plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{alpha}{the significance level; default is 0.5}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a list of two objects:
\describe{
  \item{statistic}{the data frame object of stability analysis results:}
  \itemize{
    \item{\code{S1}-value of genotype}
    \item{\code{Z1}-value of genotype}
    \item{\code{S2}-value of genotype}
    \item{\code{Z2}-value of genotype}
}
  \item{scores}{the data frame object of summary results:}
  \itemize{
    \item{\code{Z1.sum} sum of Z1}
    \item{\code{Z2.sum} sum of Z2}
    \item{\code{chi.ind} chi-squared for (choosen alpha level)/(number of genotypes) and one degree of freedom}
    \item{\code{chi.sum} chi-squared for choosen alpha level and number of genotypes degree of freedom}
}
}
}
\description{
This function calculates the Nassar&Huehn's stability parameters.
}
\examples{
data(exp_data)
stability.hue(exp_data,"yield","gen","env","rep")
}
\references{
Nassar, R. and M. Huehn. 1987. Studies on estimation of phenotypic stability: Tests of significance for nonparametric measures of phenotypic stability. Biometrics 43: 45-53. doi: 10.2307/2531947
}
