% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftsem_gehan_heller.R
\name{gehan_heller_estimation}
\alias{gehan_heller_estimation}
\title{Gehan-Heller Estimation of regression parameters}
\usage{
gehan_heller_estimation(
  y,
  Z,
  delta,
  binit,
  optimx.alg,
  variance.estimation,
  use.grad
)
}
\arguments{
\item{y}{Numeric vector of survival times or times to event/censoring.}

\item{Z}{Numeric matrix of covariates with observations in rows and covariates in columns.}

\item{delta}{Numeric vector indicating censoring, with 1 for an event and 0 for censored observations.}

\item{binit}{Numeric vector or matrix for initial estimates of regression coefficients.}

\item{optimx.alg}{Optimalization algorithm that will be used (see optimx package documentation for more information)}

\item{variance.estimation}{If covariance matrix will be estimated}

\item{use.grad}{Indicator wheter numerical or excact gradient will be used, default is FALSE == numerical

Covariance estimation is programmed but not tested!}
}
\value{
A list containing the estimated regression coefficients (`BETA`), residuals (`RESID`),
        and the number of iterations taken by the optimization routine (`ITERS`).
}
\description{
Gehan-Heller Estimation of regression parameters
}
\note{
The recommend use is with numerical aproximation of gradient. The true gradiet can be sensitive for initial beta values (binit).
For Covariance estimation please set the variance.estimation in control list to TRUE.
}
