% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftsem_fit.R
\name{aftsem_fit}
\alias{aftsem_fit}
\title{Semi-parametric AFT Model Fitting}
\usage{
aftsem_fit(Z, y, delta, betafirst, method, control, intercept, resample, nobs)
}
\arguments{
\item{Z}{A matrix of covariates.}

\item{y}{A vector of the response variable, typically survival times.}

\item{delta}{A censoring indicator vector where 1 indicates an uncensored observation and 0 indicates a censored observation.}

\item{betafirst}{The initial estimate of the beta coefficients.}

\item{method}{The method of estimation to use, one of "buckley", "gehan", "jin", or "gehan-poly".}

\item{control}{A list of control parameters including `eps` for convergence criterion and `maxiter` for the maximum number of iterations.}

\item{intercept}{Logical; if TRUE, include an intercept in the model.}

\item{resample}{The number of resamples to use for Monte Carlo estimation of variance; relevant for certain methods only.}

\item{nobs}{The number of observations in the data.}
}
\value{
Returns a list object of class "aftsem" containing the following components:
- `converged`: Logical indicating if the fitting procedure converged.
- `beta`: The estimated beta coefficients.
- `iters`: The number of iterations performed.
- `resid`: The residuals from the model fit. NOT THE MARTINGALE RESIDUALS
- `sampling.used`: Logical indicating if sampling was used.
- `intercept`: The estimated intercept, included if `intercept = TRUE`.
- `beta_star`: The beta coefficients estimated for each resample, included if resampling was used.
- `fe`: Number of calls of function in minimalization proccess (only available for gehan-poly and gehan-heller method)
- `covariance` Covariance matrix (only available for gehan-heller method)
}
\description{
Fits a semi-parametric accelerated failure time (AFT) model to the provided data using various methods.
}
\details{
The `aftsem_fit` function provides a way to fit a semi-parametric AFT model
to survival data with potential RIGHT censoring. Depending on the chosen method, 
different estimation techniques are used, such as Buckley-James or Gehan's method.
If resampling is required for the method, the function will generate resamples from an exponential distribution.
}
