% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rglaft.R
\name{rglaft}
\alias{rglaft}
\title{Estimates of selected univariate covariates(using regularization) in AFT model without MCMC.}
\usage{
rglaft(m, n, STime, Event, alpha, data)
}
\arguments{
\item{m}{Starting column number of covariates of study from high dimensional entered data.}

\item{n}{Ending column number of covariates of study from high dimensional entered data.}

\item{STime}{name of survival time in data.}

\item{Event}{name of event in data. 0 is for censored and 1 for occurrence of event.}

\item{alpha}{It is chosen value between 0 and 1 to know the regularization method. alpha=1 for Lasso,
alpha=0 for Ridge and alpha between 0 and 1 for elastic net regularization.}

\item{data}{High dimensional gene expression data that contains event status, survival time and and set of covariates.}
}
\value{
Matrix that contains survival information of selected covariates(selected from chosen columns using regularization) on AFT model. Uppermost covariates are more significant  than lowerone, as covariates are ordered as their increasing order of p value.
}
\description{
Provides Estimates of selected variable in parametric AFT model with smooth time functions for univariate in high dimensional gene expression data without MCMC.Incorporated variable selection has been done with regularization technique. It also deals covariates with missing values.

 @details
Survival time T for covariate x, is modelled as AFT model using
\deqn{S(T|x)=S_0(T\exp(-\eta(x;\beta)))}
and baseline survival function is modelled as
\deqn{S_0(T)=\exp(-\exp(\eta_0(log(T);\beta_0)))}
Where \eqn{\eta} and \eqn{\eta} are linear predictor.
}
\examples{
##
data(hdata)
set.seed(1000)
rglaft(9,50,STime="os",Event="death",1,hdata)
##
}
\seealso{
pvaft, rglwbysu, rglwbysm
}
\author{
Atanu Bhattacharjee, Gajendra Kumar Vishwakarma and Pragya Kumari
}
