% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmodel.R
\name{logitexp}
\alias{logitexp}
\title{Exponential logit model for two variables}
\usage{
logitexp(v.fever, v.density)
}
\arguments{
\item{v.fever}{numeric vector of 0/1 indicating fever or equivalent}

\item{v.density}{numeric vector of values >= 0 indicating the density}
}
\value{
S3 object of class afmodel with 4 components: data, model, coefficients
and the estimated attributable fraction.
}
\description{
Fit a logit model of v.density on v.fever v.density with
a exponential coefficient for the v.density
}
\details{
logit(v.fever) ~ beta * (v. density ^ tau)

This corresponds to the  model 3 describe by
Smith, T., Schellenberg, J.A., Hayes, R., 1994.
Attributable fraction estimates and case definitions for malaria
in endemic areas. Stat Med 13, 2345–2358.
}
\examples{
{
# Get the sample data
head(malaria_df1)
fit <- logitexp(malaria_df1$fever, malaria_df1$density)
fit
senspec(fit,  c(1,100,500,1000,2000,4000,8000,16000, 32000,54000,100000))
}
}
\seealso{
\code{\link{senspec}}
}
