% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rehab_dat}
\alias{rehab_dat}
\title{Zombie rehabilitation data}
\format{
A tibble with 190 rows and 6 variables:
\describe{
  \item{id}{Participant ID}
  \item{id_clin}{Factor that codes which of 10 clinics the participant attended}
  \item{intervention}{Factor that codes which arm of the trial the participant was randomized to (0 = wait list, 1 = gene therapy)}
  \item{resemblance}{How closely their face resembled their pre-zombified state (100\% = the participants face is exactly like their original face, 0\% the person bears no resemblance to their pre-zombified face)}
  \item{gep_level}{Factor that codes whether the participant was originally exposed to the low- (0) or high-intensity (1) genetic enhancement program at JIG\:SAW}
  \item{tse_months}{How many months since the participant completed the genetic enhancement program that resulted in their zombification}
}
}
\source{
\url{https://www.discoveringstatistics.com/books/an-adventure-in-statistics/}
}
\usage{
rehab_dat
}
\description{
A dataset not from Field, A. P. (2016). An adventure in statistics: the reality enigma. London: Sage, but continuing the theme of the story. At the end of the book
it is revealed that Alice used her C-gene therapy to restore the code 1318 workers to a human state. This dataset relates to her first attempt. It contains data from
190 code 1318 workers treated at 10 different clinics. Workers were randomly assigned to two arms of the trial (wait list vs.C-gene therapy) and the outcome was
how much they resembled their pre-zombie state (as a percentage). The zombification occurred as a result of these workers entering JIG:SAWs genetic enhancement programme (GEP),
and additional variables quantify how long it has been since they entered this programme (i.e., how long have they been a zombie) and whether they were originally
exposed to the low- or high-intensity GEP.
}
\keyword{datasets}
