% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R, R/ContinuousPrior.R,
%   R/PointMassPrior.R
\name{predictive_pdf}
\alias{predictive_pdf}
\alias{predictive_pdf,DataDistribution,ContinuousPrior,numeric-method}
\alias{predictive_pdf,DataDistribution,PointMassPrior,numeric-method}
\title{Predictive PDF}
\usage{
predictive_pdf(dist, prior, x1, n1, ...)

\S4method{predictive_pdf}{DataDistribution,ContinuousPrior,numeric}(
  dist,
  prior,
  x1,
  n1,
  k = 10 * (prior@support[2] - prior@support[1]) + 1,
  ...
)

\S4method{predictive_pdf}{DataDistribution,PointMassPrior,numeric}(dist, prior, x1, n1, ...)
}
\arguments{
\item{dist}{a univariate \code{\link[=DataDistribution-class]{distribution}} object}

\item{prior}{a \code{\link{Prior}} object}

\item{x1}{stage-one test statistic}

\item{n1}{stage-one sample size}

\item{...}{further optional arguments}

\item{k}{number of pivots for crude integral approximation}
}
\value{
\code{numeric}, value of the predictive PDF
}
\description{
\code{predictive_pdf()} evaluates the predictive PDF of the model specified
by a \code{\link{DataDistribution}} \code{dist} and
\code{\link{Prior}} at the given stage-one outcome.
}
\examples{
tmp <- ContinuousPrior(function(x) dunif(x, .2, .4), c(.2, .4))
predictive_pdf(Normal(), tmp, 2, 20)

predictive_pdf(Normal(), PointMassPrior(.3, 1), 1.5, 20) # ~.343

}
