% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{qpAdm}
\alias{qpAdm}
\title{Calculate ancestry proportions in a set of target populations.}
\usage{
qpAdm(
  data,
  target,
  sources,
  outgroups,
  outdir = NULL,
  params = list(allsnps = "YES", summary = "YES", details = "YES")
)
}
\arguments{
\item{data}{EIGENSTRAT data object.}

\item{target}{Vector of target populations (evaluated one at a time).}

\item{sources}{Source populations related to true ancestors.}

\item{outgroups}{Outgroup populations.}

\item{outdir}{Where to put all generated files (temporary directory by default).}

\item{params}{Named list of parameters and their values. For instance,
\code{params = list(allsnps = "YES")} or \code{params = list(blgsize = 0.01)}
(or an arbitrary combination of parameters using a list with multiple named
elements).}
}
\value{
List of three components:
    1. estimated ancestry proportions
    2. ranks statistics
    3. analysis of patterns (all possible subsets of ancestry sources).
}
\description{
Calculate ancestry proportions in a set of target populations.
}
\examples{
\dontrun{# download example data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# estimate the proportion of Neandertal ancestry in a French
# individual and other associated qpAdm statistics (see detailed
# description in the tutorial vignette)
result <- qpAdm(
    target = "French",
    sources = c("Vindija", "Yoruba"),
    outgroups = c("Chimp", "Denisova", "Altai"),
    data = snps
)
}

}
