% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.2ph.R
\name{predict.ah.2ph}
\alias{predict.ah.2ph}
\title{Prediction Based on the Additive Hazards Model Fitted from Two-phase Sampling}
\usage{
\method{predict}{ah.2ph}(object, newdata, newtime, ...)
}
\arguments{
\item{object}{an object of class inhering from 'ah.2ph'.}

\item{newdata}{a dataframe of an individual's predictors.}

\item{newtime}{a given sequence of time points at which the prediction is performed.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A dataframe including the given time points, predicted hazards, their
 standard errors, their variances, the phase I component of the variance for
 predicted hazards and the phase II component of the variance.
}
\description{
This function predicts a subject's overall hazard rates at given time points
based on this subject's covariate values. The prediction function is an object
from \code{\link{ah.2ph}}. The  estimating procedures follow Hu (2014).
}
\examples{
library(survival)
### load data
nwts <- nwtsco[1:100,]

### create strata based on  institutional histology and disease status
nwts$strt <- 1+nwts$instit
### add a stratum containing all (relapsed) cases
nwts$strt[nwts$relaps==1] <- 3

### assign phase II subsampling probabilities
### oversample unfavorable histology (instit =1) and cases
### Pi = 0.5 for instit =0, Pi =1 for instit =1 and relaps =1
nwts$Pi<-  0.5 * (nwts$strt == 1) + 1 * (nwts$strt == 2) + 1 * (nwts$strt == 3)

### generate phase II sampling indicators
N <- dim(nwts)[1]
nwts$in.ph2 <-  rbinom(N, 1, nwts$Pi)

### fit an additive hazards model to  two-phase sampling data without calibration
fit1 <- ah.2ph(Surv(trel,relaps) ~ age + histol,
               data = nwts,
               ties = FALSE,
               R = in.ph2, Pi = Pi,
               robust = FALSE)

###  input the new data for prediction
newdata <- nwtsco[101,]
###  based on the fitted model fit1, perform prediction at time points t =3 and t= 5
predict(fit1, newdata, newtime = c(3,5))

### fit an additve hazards model to  two-phase sampling data with calibration
### The calibration variable is stage
fit2 <- ah.2ph(Surv(trel,relaps) ~ age + histol, data = nwts, R = in.ph2, Pi = Pi,
                                   ties = FALSE, robust = FALSE, calibration.variables = "stage")

### based on the fitted model fit2, perform prediction at time points t =3 and t= 5
predict(fit2, newdata, newtime = c(3,5))

\dontrun{
### The calibration variable is stage, when set robust = TRUE
fit3 <- ah.2ph(Surv(trel,relaps) ~ age + histol, data = nwts, R = in.ph2, Pi = Pi,
                                   ties = FALSE, robust = TRUE, calibration.variables = "stage")

### based on the fitted model fit2, perform prediction at time points t =3 and t= 5
predict(fit3, newdata, newtime = c(3,5))
}
}
\references{
Jie Hu (2014) A Z-estimation System for Two-phase Sampling with Applications
              to Additive Hazards Models and Epidemiologic Studies. Dissertation,
              University of Washington.
}
\seealso{
\code{\link{ah.2ph}} for fitting the additive hazards model with two-phase
}

