% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adass_functions.R
\name{adass.fr_eaass}
\alias{adass.fr_eaass}
\title{Evolutionary algorithm for the adaptive smoothing spline estimator (EAASS).}
\usage{
adass.fr_eaass(
  Y_fd,
  X_fd,
  basis_s,
  basis_t,
  beta_ders = NULL,
  beta_dert = NULL,
  grid_eval_ders = NULL,
  grid_eval_dert = NULL,
  rand_search_par = list(c(-4, 4), c(-4, 4), c(0, 1, 5, 10, 15), c(0, 1, 2, 3, 4), c(0,
    1, 5, 10, 15), c(0, 1, 2, 3, 4)),
  popul_size = 12,
  iter_num = 10,
  r = 0.2,
  pert_vec = c(0.8, 1.2),
  X_fd_test = NULL,
  Y_fd_test = NULL,
  progress = TRUE,
  ncores = 1,
  K = 10
)
}
\arguments{
\item{Y_fd}{An object of class fd corresponding to the response functions.}

\item{X_fd}{An object of class fd corresponding to the covariate functions.}

\item{basis_s}{B-splines basis along the \code{s}-direction of class basisfd.}

\item{basis_t}{B-splines basis along the \code{t}-direction of class basisfd.}

\item{beta_ders}{Initial estimate of the partial derivative of the coefficient function along the \code{s}-direction.
Either a matrix or a class basisfd object. If NULL no adaptive penalty is  used along the \code{s}-direction.}

\item{beta_dert}{Initial estimate of the partial derivative of the coefficient function along the \code{t}-direction.
Either a matrix or a class basisfd object. If NULL no adaptive penalty is used along the \code{t}-direction.}

\item{grid_eval_ders}{Grid of evaluation of the partial derivatives along the \code{s}-direction.}

\item{grid_eval_dert}{Grid of evaluation of the partial derivatives along the \code{t}-direction.}

\item{rand_search_par}{List containing the initial population ranges for the tuning parameters.}

\item{popul_size}{Initial population size.}

\item{iter_num}{Algorithm iterations.}

\item{r}{Truncation parameter in the exploitation phase.}

\item{pert_vec}{Perturbation parameters in the exploration phase.}

\item{X_fd_test}{Test set covariate functions. Default is NULL.
If \code{X_fd_test} and \code{Y_fd_test} are both provided the prediction error on the test set is used as performance metric in place of the cross-validation prediction error.}

\item{Y_fd_test}{Test set response functions. Default is NULL.
If \code{X_fd_test} and \code{Y_fd_test} are both provided the prediction error on the test set is used as performance metric in place of the cross-validation prediction error.}

\item{progress}{If TRUE a progress bar is printed. Default is TRUE.}

\item{ncores}{If \code{ncores}>1, then parallel computing is used, with \code{ncores} cores. Default is 1.}

\item{K}{Number of folds. Default is 10.}
}
\value{
A list containing the following arguments:
\itemize{
\item \code{tun_par_opt}: Vector of optimal tuning parameters.

\item \code{CV}:  Estimated prediction errors.

\item \code{CV_sd}:  Standard errors of the estimated prediction errors.

\item \code{comb_list}: The combinations of tuning parameters explored.

\item \code{Y_fd}: The response functions.

\item \code{X_fd}: The covariate functions.
}
}
\description{
EAASS algorithm to choose the tuning parameters for the AdaSS estimator (Centofanti et al., 2020).
}
\examples{
library(adass)
data<-simulate_data("Scenario HAT",n_obs=100)
X_fd=data$X_fd
Y_fd=data$Y_fd
basis_s <- fda::create.bspline.basis(c(0,1),nbasis = 5,norder = 4)
basis_t <- fda::create.bspline.basis(c(0,1),nbasis = 5,norder = 4)
mod_smooth <-adass.fr(Y_fd,X_fd,basis_s = basis_s,basis_t = basis_t,tun_par=c(10^-6,10^-6,0,0,0,0))
grid_s<-seq(0,1,length.out = 5)
grid_t<-seq(0,1,length.out = 5)
beta_der_eval_s<-fda::eval.bifd(grid_s,grid_t,mod_smooth$Beta_hat_fd,sLfdobj = 2)
beta_der_eval_t<-fda::eval.bifd(grid_s,grid_t,mod_smooth$Beta_hat_fd,tLfdobj = 2)
mod_adsm<-adass.fr_eaass(Y_fd,X_fd,basis_s,basis_t,
                        beta_ders=beta_der_eval_s, beta_dert=beta_der_eval_t,
                        rand_search_par=list(c(-8,4),c(-8,4),c(0,0.1),c(0,4),c(0,0.1),c(0,4)),
                        grid_eval_ders=grid_s, grid_eval_dert=grid_t,
                        popul_size = 1,ncores=1,iter_num=1)

}
\references{
Centofanti, F., Lepore, A., Menafoglio, A., Palumbo, B., Vantini, S. (2023).
Adaptive Smoothing Spline Estimator for the Function-on-Function Linear Regression Model.
\emph{Computational Statistics 38(1), 191–216}.
}
\seealso{
\code{\link{adass.fr_eaass}}
}
