% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qprior.R
\name{qprior}
\alias{qprior}
\title{Prior Quantile Function}
\usage{
qprior(
  p,
  prior_par = list(mu_psi = 0, sigma_psi = 1, mu_beta = 0, sigma_beta = 1),
  what = "logor",
  hypothesis = "H1"
)
}
\arguments{
\item{p}{numeric vector with probabilities.}

\item{prior_par}{list with prior parameters. This list needs to contain the
following elements: \code{mu_psi} (prior mean for the normal prior on the
test-relevant log odds ratio), \code{sigma_psi} (prior standard deviation
for the normal prior on the test-relevant log odds ratio), \code{mu_beta}
(prior mean for the normal prior on the grand mean of the log odds),
\code{sigma_beta} (prior standard deviation for the normal prior on the
grand mean of the log odds). Each of the elements needs to be a real number
(the standard deviations need to be positive). The default are standard
normal priors for both the log odds ratio parameter and the grand mean of
the log odds parameter.}

\item{what}{character specifying for which quantity the prior quantile
function should be evaluated. Either \code{"logor"} (i.e., log odds ratio)
, \code{"or"} (i.e., odds ratio), \code{"rrisk"} (i.e., relative risk, the
ratio of the "success" probability in the experimental and the control
condition), or \code{"arisk"} (i.e., absolute risk, the difference of the
"success" probability in the experimental and control condition).}

\item{hypothesis}{character specifying whether to evaluate the quantile
function for a two-sided prior (i.e., "H1"), a one-sided prior with lower
truncation point (i.e., "H+"), or a one-sided prior with upper truncation
point (i.e., "H-").}
}
\value{
numeric vector with the values of the prior quantile function.
}
\description{
Function for evaluating the prior quantile function.
}
\examples{
# prior parameters
prior_par <- list(mu_psi = 0, sigma_psi = 1,
                  mu_beta = 0, sigma_beta = 1)

# evaluate prior quantile function
qprior(p = .1, prior_par = prior_par, what = "logor")
qprior(p = .7, prior_par = prior_par, what = "or")
qprior(p = .9, prior_par = prior_par, what = "rrisk")
qprior(p = .7, prior_par = prior_par, what = "arisk")

# also works for vectors
qprior(p = c(.1, .2, .5, .7, .9), prior_par = prior_par, what = "logor")
}
\author{
Quentin F. Gronau
}
