% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.double.R
\docType{class}
\name{VT.forest.double}
\alias{VT.forest.double}
\title{Difft by double random forest}
\description{
A reference class to compute twins via double random forests
}
\details{
\code{VT.forest.double} extends \code{VT.forest}.

\eqn{E(Y|T = 1)} if \eqn{T_i = 1} is estimated by OOB predictions from
\code{model_trt1}. 
\eqn{E(Y|T = 0)} if \eqn{T_i = 0} is estimated by OOB predictions from
\code{model_trt0}.
This is what \code{computeTwin1()} does.

Then \eqn{E(Y|T = 1)} if \eqn{T_i = 0} is estimated by model_trt1.
Then \eqn{E(Y|T = 0)} if \eqn{T_i = 1} is estimated by model_trt1.
This is what \code{computeTwin2()} does.
}
\section{Fields}{

\describe{
\item{\code{model_trt1}}{a caret/RandomForest/randomForest object for treatment T =
1}

\item{\code{model_trt0}}{a caret/RandomForest/randomForest object for treatment T =
0}

\item{\code{...}}{field from parent class : \code{\link{VT.forest}}}
}}

\section{Methods}{

\describe{
\item{\code{computeTwin1()}}{Compute twin1 with OOB predictions from double forests. See details.}

\item{\code{computeTwin2()}}{Compute twin2 by the other part of data in the other forest. See details.}
}}

\seealso{
\code{\link{VT.difft}}, \code{\link{VT.forest}},
  \code{\link{VT.forest.one}}
}
