% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{format_pkncaconc_data}
\alias{format_pkncaconc_data}
\title{Create PK Concentration Dataset}
\usage{
format_pkncaconc_data(
  ADNCA,
  group_columns,
  time_column = "AFRLT",
  rrlt_column = "ARRLT",
  route_column = "ROUTE"
)
}
\arguments{
\item{ADNCA}{A data frame containing the ADNCA data.}

\item{group_columns}{A character vector specifying the columns to group by.}

\item{time_column}{A character string specifying the time column.}

\item{rrlt_column}{A character string specifying the time since last dose column.}

\item{route_column}{A character string specifying the route column.}
}
\value{
A data frame containing the filtered and processed concentration data.
}
\description{
This function creates a pharmacokinetic concentration dataset from the provided ADNCA data.
}
\details{
The function performs the following steps:
\itemize{
\item Checks for required columns and data.
\item Filters out rows with EVID = 0 and PARAMCD containing "DOSE"
(dosing data- not CDISC standard)
\item Creates \code{DOSNOA} variable, sequential numbers based on time of dose
\item Creates a 'std_route' column with PKNCA values "intravascular" or "extravascular"
based on route_column (ROUTE, CDISC: C66729).
\item Arranges the data by group_columns.
}
}
\examples{
adnca <- read.csv(system.file("shiny/data/Dummy_data.csv", package = "aNCA"))
conc_data <- format_pkncaconc_data(ADNCA = adnca,
                                   group_columns = c("STUDYID", "DOSETRT", "USUBJID", "PARAM"),
                                   time_column = "AFRLT",
                                   rrlt_column = "ARRLT",
                                   route_column = "ROUTE")
}
