% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDRcutoff.R
\name{FDRcutoff}
\alias{FDRcutoff}
\title{Determine optimal cutoff thresholds based on Screen Strength analysis.}
\usage{
FDRcutoff(zetaData, negGene, posGene, nonExpGene, combine = FALSE)
}
\arguments{
\item{zetaData}{A data frame containing zeta scores calculated by the Zeta() function. Should have columns 'Zeta_D' and 'Zeta_I' representing decrease and increase direction scores, respectively.}

\item{negGene}{A data frame or matrix containing negative control gene/siRNA identifiers. The first column should contain gene/siRNA names that match the row names in zetaData.}

\item{posGene}{A data frame or matrix containing positive control gene/siRNA identifiers. The first column should contain gene/siRNA names that match the row names in zetaData.}

\item{nonExpGene}{A data frame or matrix containing non-expressed gene/siRNA identifiers. These genes are used to estimate the baseline false discovery rate. The first column should contain gene/siRNA names that match the row names in zetaData.}

\item{combine}{Logical. Whether to combine decrease and increase direction zeta scores. Default is FALSE. When TRUE, uses the sum of Zeta_D and Zeta_I; when FALSE, analyzes each direction separately.}
}
\value{
A list containing:
  \item{FDR_cutOff}{A data frame with 6 columns:
    \itemize{
      \item Cut_Off: Zeta score threshold
      \item aFDR: Apparent false discovery rate at this threshold
      \item SS: Screen Strength = 1 - (aFDR / bFDR)
      \item TotalHits: Total number of hits at this threshold
      \item Num_nonExp: Number of non-expressed genes among hits
      \item Type: Direction ("Decrease", "Increase", or "Combine")
    }
  }
  \item{plotList}{A list with two ggplot objects:
    \itemize{
      \item Zeta_type: Jitter plots showing zeta score distributions by gene type
      \item SS_cutOff: Screen Strength curves showing SS vs. zeta score threshold
    }
  }
}
\description{
This function calculates optimal cutoff thresholds for identifying significant hits in high-throughput screening data using Screen Strength (SS) analysis. It evaluates the trade-off between sensitivity and specificity by calculating the ratio of apparent FDR to baseline FDR across different zeta score thresholds.
}
\details{
The function performs the following analysis:
\enumerate{
  \item Categorizes genes into types: "Gene" (test genes), "Positive" (positive controls), "NS_mix" (negative controls), and "non_exp" (non-expressed genes)
  \item Calculates baseline FDR (bFDR) as the proportion of non-expressed genes in the entire dataset
  \item For each zeta score threshold, calculates apparent FDR (aFDR) as the proportion of non-expressed genes among hits
  \item Computes Screen Strength: SS = 1 - (aFDR / bFDR)
  \item Generates plots showing zeta score distributions and SS curves
}

Higher Screen Strength values indicate better separation between true hits and false positives. Users can select appropriate thresholds based on desired sensitivity/specificity trade-offs.
}
\examples{
data(nonExpGene)
data(negGene)
data(posGene)
data(ZseqList)
data(countMat)
ZscoreVal <- Zscore(countMat, negGene)
zetaData <- Zeta(ZscoreVal, ZseqList, SVM=FALSE)
cutoffval <- FDRcutoff(zetaData, negGene, posGene, nonExpGene, combine=TRUE)

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{FDR}
\keyword{ZetaSuite}
\keyword{cutoff}
\keyword{screen}
\keyword{strength}
