
#' A dataset from the HF-ACTION trial
#'
#' @description The Heart Failure: A Controlled Trial Investigating Outcomes of Exercise Training
#' (HF-ACTION) study was conducted between 2003--2007 to investigate whether
#'adding exercise training to the usual care of heart failure patients improves their cardiovascular outcomes (O'Conner et al., 2009).
#' This is a mock dataset consisting of 963 patients with baseline information about
#' heart failure etiology.
#'
#'
#'
#' @format A data frame with 1,315 rows and 5 variables:
#' \describe{
#'   \item{id}{Unique patient identifier.}
#'   \item{time}{Event time (months).}
#'   \item{status}{Event type; 2 = recurrent hospitalization, 1 = death, 0 = censoring.}
#'   \item{Training}{1 = exercise training, 0 = usual care.}
#'   \item{HF.etiology}{1 = ischemic, 0 = non-ischemic.}
#'   }
#' @references O'CONNOR, C. M., WHELLAN, D. J., LEE, K. L., KETEYIAN, S. J.,
#'  COOPER, L. S., ELLIS, S. J., LEIFER, E. S.,
#' KRAUS, W. E., KITZMAN, D. W., BLUMENTHAL, J. A. et al. (2009).
#' Efficacy and safety of exercise training in
#'  patients with chronic heart failure: Hf-action randomized controlled trial.
#'  J. Am. Med. Assoc. 301, 1439--1450.
"hfmock"
