% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveletFittingarma.R
\name{WaveletFittingarma}
\alias{WaveletFittingarma}
\title{Wavelet-ARIMA hybrid model for forecasting}
\usage{
WaveletFittingarma(
  ts,
  filter = "haar",
  Waveletlevels,
  boundary = "periodic",
  FastFlag = TRUE,
  MaxARParam,
  MaxMAParam,
  NForecast
)
}
\arguments{
\item{ts}{univariate time series}

\item{filter}{Wavelet filter use in the decomposition}

\item{Waveletlevels}{The level of wavelet decomposition}

\item{boundary}{The boundary condition of wavelet decomposition}

\item{FastFlag}{The FastFlag condition of wavelet decomposition: True or False}

\item{MaxARParam}{The maximum AR order for auto.arima}

\item{MaxMAParam}{The maximum MA order for auto.arima}

\item{NForecast}{The forecast horizon: A positive integer}
}
\value{
\itemize{
  \item Finalforecast - Forecasted value
  \item FinalPrediction - Predicted value of train data
}
}
\description{
Fits the time series data by using hybrid Wavelet-ARIMA algorithm.
}
\examples{
N <- 100
PHI <- 0.2
THETA <- 0.1
SD <- 1
M <- 0
D <- 0.2
Seed <- 123
set.seed(Seed)
Sim.Series <- fracdiff::fracdiff.sim(n = N,ar=c(PHI),ma=c(THETA),d=D,rand.gen =rnorm,sd=SD,mu=M)
simts <- as.ts(Sim.Series$series)
WaveletForecast<-WaveletFittingarma(ts=simts,filter ='la8',Waveletlevels=floor(log(length(simts))),
MaxARParam=5,MaxMAParam=5,NForecast=5)
}
\references{
\itemize{
\item Aminghafari, M. and Poggi, J.M. 2012. Nonstationary time series forecasting using wavelets and kernel smoothing. Communications in Statistics-Theory and Methods, 41(3),485-499.
\item Paul, R.K. A and Anjoy, P. 2018. Modeling fractionally integrated maximum temperature series in India in presence of structural break. Theory and Applied Climatology 134, 241–249.
}
}
