% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_bc_cwt.R
\name{bc_cwt}
\alias{bc_cwt}
\title{CWT based quantile mapping}
\usage{
bc_cwt(
  data,
  subset,
  variable,
  theta = 0.1,
  QM = c("MBC", "MRS", "QDM"),
  number_sim = 5,
  wavelet = "morlet",
  dt = 1,
  dj = 1,
  method = "M2",
  block = 3,
  seed = NULL,
  PR.cal = FALSE,
  do.plot = FALSE,
  ...
)
}
\arguments{
\item{data}{a list of input dataset}

\item{subset}{a index of number denoting the subset for calibration}

\item{variable}{a character string denoting the type of variable.}

\item{theta}{threshold of rainfall.}

\item{QM}{a character string denoting the qm method used.}

\item{number_sim}{The total number of realizations.}

\item{wavelet}{a character string denoting the wavelet filter to use in calculating the CWT.}

\item{dt}{sampling resolution in the time domain.}

\item{dj}{sampling resolution in the frequency domain.}

\item{method}{Shuffling method, M1: non-shuffling and M2: shuffling. M2 by default.}

\item{block}{Block size.}

\item{seed}{Seed for shuffling process.}

\item{PR.cal}{Logical value for phase randomization of calibration.}

\item{do.plot}{Logical value for ploting.}

\item{...}{Additional arguments for QDM.}
}
\value{
a list of post-processed data
}
\description{
CWT based quantile mapping
}
