% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transition_matrix.R
\name{get_transition_matrix}
\alias{get_transition_matrix}
\title{get_transition_matrix}
\usage{
get_transition_matrix(path, cluster_t, threshold, cells_t)
}
\arguments{
\item{path}{Character string with the path to the folder with the outputof the function compute_all_transport_maps from pythonpackage WOT.}

\item{cluster_t}{Vector with cluster assignment for cells at time t.
The length is equal to the length of \emph{cells_t}.}

\item{threshold}{Numeric value. Only entry of the transition matrix with weight equal or above \emph{threshold} are kept.}

\item{cells_t}{Character vector with the name of cells at time t for which we want to obtain the transition matrix.}
}
\value{
A matrix with row names equal to \emph{level_t_plus} and column names equal to
the levels of \emph{cluster_t}.
}
\description{
The output of \emph{compute_all_transport_maps} from pythonpackage \emph{WOT} is a matrix. Each entry (i,j) describes the
transition probability of cell i at time t towards cluster j at time t+1. From this matrix,
the average of the transition probability for all the cells at time t belonging to the same cluster is computed. Finally only the entries of the resulting matrix with above
\emph{threshold} are kept. The row names of the final matrix are equal to \emph{level_t_plus}, while the column names are equal to
the levels of \emph{cluster_t}.
}
\seealso{
\url{https://broadinstitute.github.io/wot/}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
