% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{computeGammaUnSVD}
\alias{computeGammaUnSVD}
\title{Internal function: Computes unrestricted one-step ML estimator for transformed
regressors in walsNB}
\usage{
computeGammaUnSVD(
  U,
  V,
  singularVals,
  ellStart,
  gStart,
  epsilonStart,
  qStart,
  y0Start,
  tStart,
  psiStart
)
}
\arguments{
\item{U}{Left singular vectors of \eqn{\bar{Z}} or \eqn{\bar{Z}_{1}}
from \code{\link[base]{svd}}.}

\item{V}{Right singular vectors of \eqn{\bar{Z}} or \eqn{\bar{Z}_{1}}
from \code{\link[base]{svd}}.}

\item{singularVals}{Singular values of \eqn{\bar{Z}} or \eqn{\bar{Z}_{1}}
from \code{\link[base]{svd}}.}

\item{ellStart}{Vector \eqn{\bar{\ell}} see details.}

\item{gStart}{Derivative of dispersion parameter \eqn{\rho} of NB2 with
respect to \eqn{\alpha = \log(\rho)} evaluated at starting values of
one-step ML. \code{gStart} is a scalar.
See section "ML estimation" of  \insertCite{huynhwalsnb;textual}{WALS}.}

\item{epsilonStart}{Scalar \eqn{\bar{\epsilon}}, see section
"One-step ML estimator" of \insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{qStart}{Vector \eqn{\bar{q}}, see section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{y0Start}{Vector \eqn{\bar{y}_0}, see section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{tStart}{Scalar \eqn{\bar{t}}, see section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{psiStart}{Diagonal matrix \eqn{\bar{\Psi}}, see section
"One-step ML estimator" of \insertCite{huynhwalsnb;textual}{WALS} for definition.}
}
\description{
Computes one-step ML estimator for the unrestricted model in walsNB
(coefs of transformed regressors \eqn{\bar{Z}})
by using SVD on entire transformed design matrix \eqn{\bar{Z}}.
The matrix \eqn{\bar{Z}} should have full column rank.
}
\details{
See section "Simplification for computing \eqn{\tilde{\gamma}_{u}}"
in the appendix of \insertCite{huynhwals;textual}{WALS} for details of the
implementation and for the definitions of argument \code{ellStart}.

All parameters that contain "start" feature the starting values for the
one-step ML estimation of submodels. See section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for details.

Uses \code{\link[WALS]{svdLSplus}} under-the-hood.
}
\references{
\insertAllCited{}
}
