% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_distance.R
\name{point_distance}
\alias{point_distance}
\title{Computes the distance of a set of points to a user defined point.}
\usage{
point_distance(data, point, message)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud or voxel cloud.}

\item{point}{a vector of length 3 containing the x, y and z coordintes of the reference point.}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
A vector containing the distance values of the points.
}
\description{
Computes the distance of a set of points to a user defined point.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- compute distance to the crown centre
tls[,dist:=VoxR::point_distance(tls,c(mean(x),mean(y),mean(z)))]

#- round distance values for visualization
tls[,dist:=round(dist*100)]

#- plot the distance to crown centre
cols=rev(rainbow(max(tls$dist)+1,end=4/6)) # color scale
rgl::open3d()
rgl::plot3d(tls,col=cols[tls$dist+1],add=TRUE)
}
\references{
Lecigne, B., Delagrange, S., & Messier, C. (2018). Exploring trees in three dimensions: VoxR, a novel voxel-based R package dedicated to
            analysing the complex arrangement of tree crowns. Annals of botany, 121(4), 589-601.
}
