% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_voxels_full_grid.R
\name{plot_voxels_full_grid}
\alias{plot_voxels_full_grid}
\title{Voxel cloud visualization when voxel cloud includes the empty voxels.}
\usage{
plot_voxels_full_grid(data, res, ecol, fcol, lwd, alpha, plot, message)
}
\arguments{
\item{data}{a data.frame or data.table containing at least the voxel cloud x, y, z coordinates.}

\item{res}{numeric. The voxel resolution. If not provided, the function will guess it.}

\item{ecol}{color for the edges of empty voxels.}

\item{fcol}{color for the facets of filled voxels.}

\item{lwd}{numeric. The line width for the edges of empty voxels.}

\item{alpha}{numeric. The transparency of the voxel facets for filled voxels.}

\item{plot}{logical. Plot the voxels ? See return for mesh capture. Default = TRUE.}

\item{message}{logical. If FALSE removes the message from the resolution guessing.}
}
\value{
At anytime the mesh object that enables to plot the voxels can be captured to plot it using
        the \code{\link[rgl]{shade3d}} function from rgl. The returned object is a list containing
        the 3D mesh of filled and empty voxels separately.
}
\description{
Voxel cloud visualization when voxel cloud includes the empty voxels.
             Filled voxels are plotted as plain vertices and only the edges of empty voxels are plotted.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- voxelisation with full.grid option
voxels=VoxR::vox(tls,0.3,full.grid = TRUE)

#- plot the voxels
VoxR::plot_voxels_full_grid(voxels)
}
