% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_voxels.R
\name{plot_voxels}
\alias{plot_voxels}
\title{Voxel cloud visualization.}
\usage{
plot_voxels(data, res, type, lcol, fcol, lwd, alpha, plot, message)
}
\arguments{
\item{data}{a data.frame or data.table containing at least the voxel cloud x, y, z coordinates.}

\item{res}{numeric. The voxel resolution. If not provided, the function will guess it.}

\item{type}{character. How to represent a voxel ? If "w" only the voxel hedges are plotted,
if "p" plain voxels are plotted, if "b" both hedges and plain voxels are plotted. Default = "b".}

\item{lcol}{the line color for \code{type} = "w" or "b".}

\item{fcol}{the facets color for \code{type} = "p" or "b".}

\item{lwd}{numeric. The line width for \code{type} = "w" or "b".}

\item{alpha}{numeric. The transparency of the voxel faces for \code{type} = "p" or "b".}

\item{plot}{logical. Plot the voxels ? See return for mesh capture. Default = TRUE.}

\item{message}{logical. Removes the message from the resolution guessing. Default = FALSE.}
}
\value{
If \code{plot = TRUE}, the 3D plot of voxels is plotted. At anytime the mesh object that enables
        to plot the voxels can be captured and to be plotted using the
        \code{\link[rgl]{shade3d}} function from rgl.
        The returned object is a list containing the 3D mesh of the voxel cloud and all additionnal fields
        of the input data.
}
\description{
Voxel cloud visualization.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- voxelisation
voxels = VoxR::vox(tls,res=0.05)

#- plot the voxels
VoxR::plot_voxels(voxels)

#- capture the voxels mesh to plot with color scale
###- number of points in the voxel
voxels_mesh = VoxR::plot_voxels(voxels,plot = FALSE) # capture the mesh
colors=rev(rainbow(max(voxels_mesh$additionnal$npts),end=4/6)) # color scale
rgl::open3d()
rgl::shade3d(voxels_mesh$mesh,col=colors[round(voxels_mesh$additionnal$npts)]
             ,lit=FALSE,alpha=0.5) # plot

###- distance from the crow center
# compute distnce
voxels[,distance:=round(VoxR::point_distance(voxels[,1:3],c(mean(x),mean(y),mean(z)))*100)]
voxels_mesh = VoxR::plot_voxels(voxels,plot = FALSE) # capture mesh
cols=rev(rainbow(max(voxels_mesh$additionnal$distance),end=4/6)) # color scale
rgl::open3d()
rgl::shade3d(voxels_mesh$mesh,col=cols[round(voxels_mesh$additionnal$distance)]
             ,lit=FALSE,alpha=0.5) # plot
}
