% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_projection.R
\name{plot_projection}
\alias{plot_projection}
\title{Visualization of a projected voxel cloud.}
\usage{
plot_projection(data, var, th, palette)
}
\arguments{
\item{data}{a data.frame or data.table containing the output of the \link{project_voxels} function:
x, y, number of voxels, number of points and ratio of a projected voxel cloud.}

\item{var}{character. The variable to plot: "nvox" for the number of voxels per pixel, "npts" for
the number of points or "ratio" for the ratio npts/nvox. Default is "nvox".}

\item{th}{numeric between 0 and 1. A quantile threshold that defines the maximum value of \code{var}
to be plotted. Values > th are replaced by the value of th. Desabled by default.}

\item{palette}{a color palette to use for plotting.}
}
\description{
Visualization of a projected voxel cloud.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- voxelisation
voxels = VoxR::vox(tls,0.05)

#- project into the xy plan
project = VoxR::project_voxels(voxels,"xy")

#- plot the number of voxels
VoxR::plot_projection(project,var = "nvox")

#- plot the number of points
VoxR::plot_projection(project,var = "npts")

#- plot the ratio npts/nvox
VoxR::plot_projection(project,var = "ratio")

#- plot the number of voxels with different color palette
VoxR::plot_projection(project,palette = terrain.colors)

#- plot the number of voxels with a 95\% percentile threshold
VoxR::plot_projection(project,th = 0.95)
}
\references{
Lecigne, B., Delagrange, S., & Messier, C. (2018). Exploring trees in three dimensions: VoxR, a novel voxel-based R package dedicated to
            analysing the complex arrangement of tree crowns. Annals of botany, 121(4), 589-601.
}
