% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Box_counting.R
\name{box_counting}
\alias{box_counting}
\title{Computes fractal dimension using the box counting method.}
\usage{
box_counting(data, min_vox_size, store_fit, message)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud.}

\item{min_vox_size}{numeric. The minimum size of a voxel. Default = 0.01.}

\item{store_fit}{logical. If TRUE, the parameters linear model's fit are returned. Default = FALSE.}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
If \code{store_fit = FALSE} only the fractal dimension is returned. If \code{store_fit = TRUE}
                            the parameters of the linear model used to estimate the fractal dimension and
                            a table containing the number of boxes (i.e. voxels) at any resolution are
                            returned in a list in addition to the fractal dimension.
}
\description{
Computes fractal dimension using the box counting method.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- box counting
FD = VoxR::box_counting(tls,store_fit = TRUE)

#- fractal dimension
FD$fractal_dim
#- linear model fit
FD$fit_summary
#- plot fit
plot(log(FD$fit_table$N)~log(1/FD$fit_table$res))
abline(FD$fit_summary)
}
\references{
Seidel, D. (2018). A holistic approach to determine tree structural complexity based on laser
             scanning data and fractal analysis. Ecology and evolution, 8(1), 128-134.
}
