% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screenVCM.R
\name{screenVCM}
\alias{screenVCM}
\title{Perform screening for ultrahigh-dimensional varying coefficient model}
\usage{
screenVCM(X, Y, U)
}
\arguments{
\item{X}{Matrix of predictors to be screened. There should be one row for each
observation.}

\item{Y}{Vector of responses.  It should have the same length as the number of
rows of X.}

\item{U}{Covariate, with which coefficient functions vary.}
}
\value{
A list with following components:
   CORR_sq A vector of the unconditioned squared correlation with length equal to
           the number of columns in the input matrix X. The hgh the unconditioned
           squared correlation is, the more desirable it is to retain the corresponding
           X covariate in a later predictive model.
   rank Vector for the rank of the predictors in terms of the conditional correlation
        ( \eqn{\hat{rho}*_j} in the paper). This will have length equal to the number of columns
        in the input matrix X, and will consist of a permutation of the integers 1
        through that length. A rank of 1 indicates the feature which appears to have
        the best marginal predictive performance with largest  \eqn{\hat{rho}*_j}, 2 represents
        the second best and so forth.
}
\description{
Implements a screening procedure proposed by Liu, Li and
 Wu(2014) for varying coefficient models with
 ultra-high dimensional predictors.

   The function code is adapted from the relevant authors' code. Special thanks are due to
   Jingyuan Liu for providing some of the code upon which this function is based.
}
\examples{
set.seed(12345678)
results <- simulateVCM(p=400,
                       trueIdx = c(2, 100, 300),
                       betaFun = function(U) {
                         beta2 <- 2*I(U>0.4)
                         beta100 <- 1+U
                         beta300 <- (2-3*U)^2
                         return(c(beta2,
                                  beta100,
                                  beta300))
                         })
screenResults<- screenVCM(X = results$X,
                          Y = results$Y,
                          U = results$U)
rank <- screenResults$rank
unlist(rank)
trueIdx <- c(2,100,400, 600, 1000)
rank[trueIdx]
}
\references{
Liu, J., Li, R., & Wu, R. (2014). Feature selection for varying coefficient
            models with ultrahigh-dimensional covariates. Journal of the American Statistical
            Association, 109: 266-274. <DOI:10.1080/01621459.2013.850086>
}
\keyword{dimensional}
\keyword{feature}
\keyword{models}
\keyword{regression}
\keyword{screening}
\keyword{selection}
\keyword{ultra-high}
\keyword{variable}
\keyword{varying-coefficient}
