% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VBV.R
\name{moving.estimation}
\alias{moving.estimation}
\title{moving.estimation -- estimate locally optimized trend and season figures}
\usage{
moving.estimation(t.vec, y.vec, p, q.vec, m, base.period, lambda1, lambda2)
}
\arguments{
\item{t.vec}{vector of points in time as integers}

\item{y.vec}{vector of data}

\item{p}{maximum exponent in polynomial for trend}

\item{q.vec}{vector containing frequencies to use for seasonal component, given as integers, i.e. c(1, 3, 5) for 1/2\emph{pi, 3/2}pi, 5/2*pi (times length of base period)}

\item{m}{width of moving window}

\item{base.period}{base period in number of observations, i.e. 12 for monthly data with yearly oscillations}

\item{lambda1}{penalty weight for smoothness of trend}

\item{lambda2}{penalty weight for smoothness of seasonal component}
}
\value{
A dataframe with the following components:
\itemize{
\item{data}{original data y.vec}
\item{trend}{vector of estimated trend of length length(y.vec)}
\item{season}{vector of estimated season of length length(y.vec)}
}
}
\description{
moving.estimation -- estimate locally optimized trend and season figures
}
\note{
lambda1 == lambda2 == Inf result in estimations of the original Berliner Verfahren
}
