% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.varshrinkest.R
\name{summary.varshrinkest}
\alias{summary.varshrinkest}
\title{Summary method for an object of class "varshrinkest",
VAR parameters estimated by VARshrink()}
\usage{
\method{summary}{varshrinkest}(object, equations = NULL, ...)
}
\arguments{
\item{object}{An object of class "varshrinkest", usually
a result of call to "VARshrink()".}

\item{equations}{Subset of names of endogenous time series variables
to summarize.}

\item{...}{Currently not used.}
}
\value{
Returns a list with class attribute "varshsum" and "varsum" which
contains the following elements: names, logLik, obs, roots, type, call,
varresult, covres, corres, Sigma, dof.
}
\description{
Extend \code{summary.varest()} to the class "varshrinkest" to incorporate
adapted methods for the new classes:
\code{summary.shrinklm()}, \code{logLik.varshrinkest()}, \code{roots_sh()}.
}
\details{
The code has been modified to eliminate direct calls to the data matrices
(\code{$y}, \code{$datamat}) and to use the effective numbers of parameters
obtained from the shrinkage estimates. The output additionally includes the
covariance matrix \code{Sigma} and the degrees-of-freedom \code{dof}
of the multivariate t-distribution for the residuals.
}
\examples{
data(Canada, package = "vars")
y <- diff(Canada)
estim <- VARshrink(y, p = 2, type = "const", method = "ridge")
summary(estim)
}
