% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{LcvUrb}
\alias{LcvUrb}
\title{Urban adjustment for the linear coefficient of variation (Lcv)}
\usage{
LcvUrb(LCV, URBEXT, DeUrb = FALSE)
}
\arguments{
\item{LCV}{the Lcv (numeric)}

\item{URBEXT}{quantification of urban and suburbanisation for the subject catchment (URBEXT2015)}

\item{DeUrb}{logical argument with a default of FALSE. If set to TRUE, de-urbanisation adjustment is performed, if FALSE, urbanisation adjustment is performed}
}
\value{
The urban adjust Lcv or the de-urbanised Lcv
}
\description{
Urbanises or de-urbanises the Lcv using the FEH2025 methods
}
\examples{
# Apply a de-urbanisation with an LCV of 0.21 and an URBEXT of 0.1138
LcvUrb(0.21, 0.1138, DeUrb = TRUE)

# Apply and urban adjustment using LCV 0.196 and URBEXT of 0.1138
LcvUrb(0.196, 0.1138)

}
\author{
Anthony Hammond
}
