% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_datasets.R
\docType{data}
\name{CallCentre_KPI}
\alias{CallCentre_KPI}
\title{Data: CallCentre_KPI}
\format{
{
A dataframe with \emph{n} = 5007 observations and the following 11 variables
(levels of the variables listed in alphabetical order):
\itemize{
\item \strong{ID_Call} (\code{int}): call identification
\item \strong{Day} (\code{factor}): weekday of the call (Mon, Tue, Wed,…, Sat)
\item \strong{Hour} (\code{num}): hour of the call
\item \strong{Cust.Type} (\code{chr}): customer’s type (Unknown, Private, Corporate)
\item \strong{Time.Auto} (\code{num}): time (in seconds) spent interacting with the
automatic responder
\item \strong{Time.Queue} (\code{num}): time (in seconds) spent waiting in the queue
for an operator
\item \strong{Time.Talk} (\code{num}): duration (in seconds) of the
(eventual) conversation with an operator
\item \strong{Reason} (\code{chr}): reason for contact (Admin -- administrative issues,
Landline -- fixed line, Mobile, and Activ/Transf -- calls related to
the activation or the transfer of a line)
\item \strong{Outcome} (\code{chr}): outcome of the call (Left.Aut_Resp -- the client
hung up before entering the queue, Left.Queue -- the client hung up
while waiting for an operator, Operator -- the  call was handled by
an operator)
\item \strong{Solved} (\code{chr}): variable indicating whether the client’s issue was
solved (No, Yes)
\item \strong{Satisf}  (\code{factor}): level of satisfaction expressed by customers
who interacted with an operator (VLow, Low, Med, High, VHigh).
}
}
}
\usage{
data(CallCentre_KPI)
}
\description{
This dataframe contains data on the calls to the call centre of a
telecommunication company. In particular, it contains information about the
calls (day and hour of the call), about the calling customer’s
characteristics (private or corporate, or unknown), and about some key
performance indicators (KPI). In particular, it contains information on the
duration of the phases before the customer eventually reaches an operator.
First, an automated system directs incoming calls to the appropriate
department based on the reason for the call; then the customer waits in a
queue until an operator becomes available. It also contains a variable
indicating whether the caller hung up during a specific phase. For those
customers whose call wad finally handled by an operator, we also know whether
their issue was solved and their level of satisfaction, expressed at the end
of the call.
}
\keyword{datasets}
