% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit2tsmodel_ucminf.R
\name{fit2tsmodel_ucminf}
\alias{fit2tsmodel_ucminf}
\title{Numerical optimization of the 2ts model}
\usage{
fit2tsmodel_ucminf(
  Y,
  R,
  Z = NULL,
  optim_criterion = c("aic", "bic"),
  lrho = c(0, 0),
  Bu,
  Bs,
  Iu,
  Is,
  Du,
  Ds,
  Wprior = NULL,
  ridge = 0,
  control_algorithm = list()
)
}
\arguments{
\item{Y}{A matrix (or 3d-array) of event counts of dimension nu by ns
(or nu by ns by n).}

\item{R}{A matrix (or 3d-array) of exposure times of dimension nu by ns
(or nu by ns by n).}

\item{Z}{(optional) A regression matrix of covariates values of dimensions
n by p.}

\item{optim_criterion}{The criterion to be used for optimization:
\code{"aic"} (default) or \code{"bic"}.}

\item{lrho}{A vector of two elements, the initial values for \eqn{\log_{10}(\varrho_u)}
and \eqn{\log_{10}(\varrho_s)}.}

\item{Bu}{A matrix of B-splines for the \code{u} time scale of dimension nu by cu.}

\item{Bs}{A matrix of B-splines for the \code{s} time scale of dimension ns by cs.}

\item{Iu}{An identity matrix of dimension nbu by nbu.}

\item{Is}{An identity matrix of dimension nbs by nbs.}

\item{Du}{The difference matrix over \code{u}.}

\item{Ds}{The difference matrix over \code{s}.}

\item{Wprior}{An optional matrix of a-priori weights.}

\item{ridge}{A ridge penalty parameter: default is 0. This is useful when, in
some cases the algorithm shows convergence problems. In this case, set to a small
number, for example \code{1e-4}.}

\item{control_algorithm}{A list with optional values for the parameters of
the iterative processes:
\itemize{
\item \code{maxiter} The maximum number of iteration for the IWSL algorithm.
Default is 20.
\item \code{conv_crit} The convergence criteria, expressed as difference between
estimates at iteration i and i+1. Default is \code{1e-5}.
\item \code{verbose} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the iteration
process.
\item \code{monitor_ev} A Boolean. Default is \code{FALSE}. If \code{TRUE} monitors the
evaluation of the model over the \code{log_10(rho_s)} values.
}}
}
\value{
An object of class \code{haz2ts} with the following elements:
\itemize{
\item \code{optimal_model} A list containing the results of the optimal model.
\item \code{optimal_logrho} A vector with the optimal values of \code{log10(rho_u)} and
\code{log10(rho_s)}.
\item \code{P_optimal} The optimal penalty matrix P.
}
}
\description{
\code{fit2tsmodel_ucminf()} performs a numerical optimization of the
AIC or BIC of the two time scales model.

It finds the optimal values of \code{log_10(rho_u)} and \code{log_10(rho_s)}
and returns the estimated optimal model.
See also \code{\link[ucminf:ucminf]{ucminf::ucminf()}}.
}
\references{
Nielsen H, Mortensen S (2024).
\emph{ucminf: General-Purpose Unconstrained Non-Linear Optimization}.
R package version 1.2.2, \url{https://CRAN.R-project.org/package=ucminf}
}
