% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trumpets.R
\name{plot_trumpets}
\alias{plot_trumpets}
\title{Trumpets}
\usage{
plot_trumpets(
  dataset = toy_data,
  rsID = "rsID",
  freq = "freq",
  A1_beta = "A1_beta",
  Analysis = "Analysis",
  Gene = "Gene",
  calculate_power = TRUE,
  show_power_curves = TRUE,
  exist_datapwr = NULL,
  threshold = c(0.7, 0.9),
  N = 1e+05,
  alpha = 5e-08,
  Nfreq = 500,
  power_color_palette = c("purple", "deeppink"),
  analysis_color_palette = c("#018571", "#a6611a")
)
}
\arguments{
\item{dataset}{Input text file with genetic association results. Columns required are rsID, freq, A1_beta, Analysis and Gene.}

\item{rsID}{(required) Single Nucleotide Polymorphism (SNP) name.}

\item{freq}{(required) allele frequency of effect SNP.}

\item{A1_beta}{(required) risk allele effect size.}

\item{Analysis}{(optional) adds colour to the type of analysis (e.g. GWAS, Sequencing).}

\item{Gene}{(optional) Candidate gene name (can be empty).}

\item{calculate_power}{(TRUE/FALSE) Calculate power curves. Choose TRUE to add power curves for a given threshold, alpha, sample size N and number of allele frequencies. Choose FALSE if you already ran powerCurves() outside or do not want to show power curves.}

\item{show_power_curves}{(TRUE/FALSE) Show power curves in plot}

\item{exist_datapwr}{Existing dataframe containing columns: freq, pos.b.for.f, neg.b.for.f, powerline.}

\item{threshold}{Required if power == TRUE. Can be a single number or a vector of statistical power thresholds.}

\item{N}{(Required if calculate_power == TRUE). Sample size used to test the association.}

\item{alpha}{(Required if calculate_power == TRUE).}

\item{Nfreq}{(Required if calculate_power == TRUE). Number of allele frequency data points generated to calculate the power curves. We recommend Nfreq>1000 for power curves with high resolution. Note that this will slow down the rendering of the plot.}

\item{power_color_palette}{A vector of colours for the power curves. Number of colors should match number of thresholds supplied.}

\item{analysis_color_palette}{A vector of colours for the analysis types.}
}
\value{
Creates a Trumpet plot with variant allele frequency (X axis, log10 scale) and effect size information (Y axis).
}
\description{
This function generates trumpet plots
}
\examples{
plot_trumpets(dataset = toy_data)
}
