% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{sub.test}
\alias{sub.test}
\title{sub.test function
This function calculates the simulated p-value of comparing the trend in subsamples from two independent samples.}
\usage{
sub.test(sam1, sam2, fn.rep2)
}
\arguments{
\item{sam1, }{the first sample.}

\item{sam2, }{the second sample}

\item{fn.rep2}{the total number of bootstrap repetitions needed for calculating the simulated p-value.}
}
\value{
critical.value the critical value of the test based on the alpha level provided

chi-stat the chisqure type test statistics value from the sample provided.

pvalue the simulated p-value.
}
\description{
sub.test function
This function calculates the simulated p-value of comparing the trend in subsamples from two independent samples.
}
\examples{
attach(seedwt.multi.subsample)
Lev.TN<-levels(TreatmentName);
Lev.Line<-levels(Line);
n<-dim(seedwt.multi.subsample)[1];
level.show=c(1:8);fn.rep3=10^2;
line.name<-Lev.Line[1]; t1.name<-Lev.TN[1];t2.name<-Lev.TN[3];
### To compare the GA treatment and the PACGA treatment from line B73
par(mfrow=c(1,2))
idx<-subset((TreatmentName==t1.name)*(Line==line.name)*(1:n),Env \%in\% level.show)
idx2<-subset((TreatmentName==t2.name)*(Line==line.name)*(1:n),Env \%in\% level.show)
boxplot(seedwt[idx]~Env[idx],xlab="ENV levels",ylab=paste('seedwt from',t1.name),
         ylim=c(0,12),cex.lab=1.5,cex.axis=1.8);
boxplot(seedwt[idx2]~Env[idx2], xlab="ENV levels",ylab=paste('seedwt from',t2.name),
         cex.lab=1.5,cex.axis=1.8);
mtext( paste ("Line Name:",line.name), side = 3,outer = TRUE, cex = 2.2,line = -3)
temp.sw1<-seedwt[idx];lab<-Env[idx]; uni.lab<-unique(lab)
sam.1<-lapply(1:length(uni.lab), function(x) temp.sw1[lab==uni.lab[x]])
temp.sw2<-seedwt[idx2];lab2<-Env[idx2]; uni.lab2<-unique(lab2)
sam.2<-lapply(1:length(uni.lab2), function(x) temp.sw2[lab2==uni.lab2[x]])
print(paste("working with line ",line.name,'and treatment',t1.name ,'vs',t2.name ))
resu<-sub.test(sam.1,sam.2,fn.rep2=fn.rep3);
dev.off()
## This will show a similar result as the first experiment of section 5 in the paper.
}
\references{
Wang, Y., Stapleton, A. E., & Chen, C. (2018). Two-sample nonparametric stochastic order inference with an application in plant physiology. Journal of Statistical Computation and Simulation, 88(14), 2668-2683.
}
