% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{pow.ana.gen.decision}
\alias{pow.ana.gen.decision}
\title{pow.ana.gen.decision function}
\usage{
pow.ana.gen.decision(mean.prob1, mean.prob2, effn.subsam1, effn.subsam2,
  N.rep = 10^1, boot.rep = 10^1, rseed = 1234, alpha.level = 0.05)
}
\arguments{
\item{mean.prob1, }{the probability that observations of a subsample is less than the ones from another subsample, in sample #1.}

\item{mean.prob2, }{the probability that observations of a subsample is less than the ones from another subsample, in sample #2.}

\item{effn.subsam1}{the subsample sizes from sample 1.}

\item{effn.subsam2}{the subsample sizes from sample 2.}

\item{N.rep}{the total number of bootstrap repetitions needed for calculating type I errors.}

\item{boot.rep}{the number of repetitions needed to calculated simulated p-value,}

\item{rseed}{a random seed.}

\item{alpha.level}{the type I error level that will be assessed.}
}
\value{
the simulated type I error.
}
\description{
This function evaluates the type I error of the proposed test.
}
\examples{
prob.vec<-c(.4,.2,.3,.6);
sub.sizes1<-c(2,4,3,5,3);sub.sizes2<-c(6,3,2,4,2)
pow.ana.gen.decision(prob.vec,prob.vec,sub.sizes1, sub.sizes1)
pow.ana.gen.decision(prob.vec,prob.vec,sub.sizes1, sub.sizes1,alpha.level=0.1)
}
\references{
Wang, Y., Stapleton, A. E., & Chen, C. (2018). Two-sample nonparametric stochastic order inference with an application in plant physiology. Journal of Statistical Computation and Simulation, 88(14), 2668-2683.
}
