% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_dim.R
\name{test.trajectory}
\alias{test.trajectory}
\title{Tree Dimension Test}
\usage{
test.trajectory(
  x,
  perm = 100,
  MST = c("boruvka", "exact"),
  dim.reduction = c("pca", "none")
)
}
\arguments{
\item{x}{matrix of input data. Rows as observations and columns as
features.}

\item{perm}{number of simulations to compute null distribution
parameters by maximum likelihood estimation.}

\item{MST}{the MST algorithm to be used in test. There are two
options: "exact" MST and "boruvka" which is approximate but faster
for large samples.}

\item{dim.reduction}{string parameter with value "pca" to perform
dimensionality reduction or "none" to not perform dimensionality
reduction before the test.}
}
\value{
A list with the following components:
\itemize{
 \item tdt_measure The tree dimension value for the given input data
 \item statistic  The S statistic calculated on the input data. S statistic is derived from tree dimension
 \item tdt_effect Effect size for tree dimension
 \item leaves Number of leaf/degree1 vertices in the MST  of the data
 \item diameter The tree diameter of MST, where each edge is of unit length
 \item p.value The pvalue for the S statistic. Pvalue measures presence of trajectory in input x.
 \item original_dimension If "pca" is selected, the number of dimensions in the original dataset
 \item pca_components If "pca" is selected, the number of pca components selected after dimensionality reduction
 \item mst A vector of edges of the mst computed on x. Length of vector is always even.
}
}
\description{
Computes the statistical significance for the presence of trajectory
in multivariate data.
}
\details{
If the input data is already after dimension reduction, use
\code{dim.reduction="none"}. The method is described in
\insertCite{Tenha:2022}{TreeDimensionTest}.
}
\references{
\insertAllCited{}
}
