% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10-helpers-spatial.R
\name{calculate_grid_distance}
\alias{calculate_grid_distance}
\title{Calculate grid distance}
\usage{
calculate_grid_distance(lon1, lat1, lon2, lat2, resolution = 0.25, unit = "km")
}
\arguments{
\item{lon1}{Origin longitude.}

\item{lat1}{Origin latitude.}

\item{lon2}{Destination longitude vector.}

\item{lat2}{Destination latitude vector.}

\item{resolution}{Grid resolution in degrees.}

\item{unit}{Distance unit.}
}
\value{
List with minimum distance and index.
}
\description{
Internal function to calculate distance with fixed grid resolution,
using coordinate discretization followed by Haversine distance calculation.
}
\details{
This method rounds coordinates to the nearest grid point based on the specified resolution,
then calculates the Haversine distance between the origin and each grid-aligned destination point.
This approach is useful for applications requiring consistent spatial discretization.
}
\note{
This implementation combines coordinate discretization with the Haversine formula
for applications requiring grid-based spatial analysis.
}
\keyword{internal}
