% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_.R
\name{subset_}
\alias{subset_}
\title{Inspect a Subset of \link[base]{data.frame}}
\usage{
subset_(x, subset, select, select_pattern, avoid, avoid_pattern)
}
\arguments{
\item{x}{a \link[base]{data.frame}}

\item{subset}{\link[base]{logical} \link[base]{expression},
see function \link[base]{subset.data.frame}}

\item{select}{\link[base]{character} \link[base]{vector},
columns to be selected,
see function \link[base]{subset.data.frame}}

\item{select_pattern}{regular expression \link[base]{regex}
for multiple columns to be selected}

\item{avoid}{\link[base]{character} \link[base]{vector},
columns to be avoided}

\item{avoid_pattern}{regular expression \link[base]{regex},
for multiple columns to be avoided}
}
\value{
Function \link{subset_} returns a \link[base]{data.frame}, with additional \link[base]{attributes}
\describe{
\item{\code{attr(,'vline')}}{\link[base]{integer} scalar,
position of a vertical line (see \code{?flextable::vline})}
\item{\verb{attr(,'jhighlight)'}}{\link[base]{character} \link[base]{vector},
names of columns to be \code{flextable::highlight}ed.}
}
}
\description{
..
}
\details{
Function \link{subset_} is different from
\link[base]{subset.data.frame}, such that
\itemize{
\item {if both \code{select} and \code{select_pattern} are missing, only variables mentioned in \code{subset} are selected;}
\item {be able to select all variables, except those in \code{avoid} and \code{avoid_pattern};}
\item {always returns \link[base]{data.frame}, i.e., forces \code{drop = FALSE}}
}
}
\examples{
subset_(trees, Girth > 9 & Height < 70)
subset_(swiss, Fertility > 80, avoid = 'Catholic')
subset_(warpbreaks, wool == 'K')

}
