% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrTest.R
\name{lrTest}
\alias{lrTest}
\title{Likelihood Ratio Test for Covariance Matrix}
\usage{
lrTest(X, alpha = 0.05)
}
\arguments{
\item{X}{A numeric matrix or data frame containing the variables.}

\item{alpha}{The significance level for the test. (default is 0.05).}
}
\value{
A data frame containing the test statistic, degrees of freedom, critical value, p-value, and test result.
}
\description{
Performs a likelihood ratio test for the covariance matrix to assess if the covariance matrix is significantly different from an identity matrix.
}
\examples{

library(MASS)

n = 50 # Sample Size
p = 5
rho = 0.1

# Building a Covariance structure with Autoregressive structure
cov_mat <- covMatAR(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test
lrTest(data, alpha = 0.01)

# Building a Covariance structure with Compound Symmetry structure
cov_mat <- covMatCS(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test
lrTest(data)

# Building a Covariance structure with Circular structure
cov_mat <- covMatC(p = p, rho = rho)
# Simulated data
data <- mvrnorm(n = n, mu = rep(0,p), Sigma = cov_mat)
# Performing the test
lrTest(data)

}
