% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_footnote_typography.R
\name{check_footnote_typography}
\alias{check_footnote_typography}
\title{Check footnote typography}
\usage{
check_footnote_typography(
  filename,
  ignore.lines = NULL,
  .report_error,
  rstudio = FALSE
)
}
\arguments{
\item{filename}{A LaTeX file.}

\item{ignore.lines}{Lines to ignore (for example, those using the word 'footnote').}

\item{.report_error}{A function to provide context to any errors.}

\item{rstudio}{(logical, default: \code{FALSE}) Should the RStudio API be used?}
}
\value{
Called for its side-effect.
}
\description{
Check footnote typography
}
\details{
See \url{https://github.com/grattan/grattex/blob/master/doc/grattexDocumentation.pdf} for full set of error conditions.
}
\examples{
\dontrun{
  tex_file <- tempfile(fileext = ".tex")
  cat("Footnote not ending with full stop.\\\\footnote{No sentence}", file = tex_file)
  check_footnote_typography(tex_file)
}

}
