% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplsMU.R
\name{simplsMU}
\alias{simplsMU}
\title{SIMPLS-type algorithm for estimating the envelope subspace}
\usage{
simplsMU(M, U, u)
}
\arguments{
\item{M}{The \eqn{p}-by-\eqn{p} positive definite matrix \eqn{M} in the envelope objective function.}

\item{U}{The \eqn{p}-by-\eqn{p} positive semi-definite matrix \eqn{U} in the envelope objective function.}

\item{u}{An integer between 0 and \eqn{n} representing the envelope dimension.}
}
\value{
Returns the estimated orthogonal basis of the envelope subspace.
}
\description{
This algorithm is a generalization of the SIMPLS algorithm in De Jong, S. (1993). See Cook (2018) Section 6.5 for more details of this generalized moment-based envelope algorithm; see Cook, Helland, and Su (2013) for a connection between SIMPLS and the predictor envelope in linear model.
}
\examples{
##simulate two matrices M and U with an envelope structure#
data <- MenvU_sim(p = 20, u = 5, wishart = TRUE, n = 200)
M <- data$M
U <- data$U
G <- data$Gamma
Gamma_pls <- simplsMU(M, U, u=5)
subspace(Gamma_pls, G)

}
\references{
De Jong, S., 1993. SIMPLS: an alternative approach to partial least squares regression. Chemometrics and intelligent laboratory systems, 18(3), pp.251-263.

Cook, R.D., Helland, I.S. and Su, Z., 2013. Envelopes and partial least squares regression. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 75(5), pp.851-877.

Cook, R.D., 2018. An introduction to envelopes: dimension reduction for efficient estimation in multivariate statistics (Vol. 401). John Wiley & Sons.
}
