% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MenvU_sim.R
\name{MenvU_sim}
\alias{MenvU_sim}
\title{Generate matrices \eqn{M} and \eqn{U}}
\usage{
MenvU_sim(
  p,
  u,
  Omega = NULL,
  Omega0 = NULL,
  Phi = NULL,
  jitter = FALSE,
  wishart = FALSE,
  n = NULL
)
}
\arguments{
\item{p}{Dimension of \eqn{p}-by-\eqn{p} matrix \eqn{M}.}

\item{u}{The envelope dimension. An integer between 0 and \eqn{p}.}

\item{Omega}{The positive definite matrix \eqn{\Omega} in \eqn{M=\Gamma\Omega\Gamma^T+\Gamma_0\Omega_0\Gamma_0^T}. The default is \eqn{\Omega=AA^T} where the elements in \eqn{A} are generated from Uniform(0,1) distribution.}

\item{Omega0}{The positive definite matrix \eqn{\Omega_0} in \eqn{M=\Gamma\Omega\Gamma^T+\Gamma_0\Omega_0\Gamma_0^T}. The default is \eqn{\Omega_0=AA^T} where the elements in \eqn{A} are generated from Uniform(0,1) distribution.}

\item{Phi}{The positive definite matrix \eqn{\Phi} in \eqn{U=\Gamma\Phi\Gamma^T}. The default is \eqn{\Phi=AA^T} where the elements in \eqn{A} are generated from Uniform(0,1) distribution.}

\item{jitter}{Logical or numeric. If it is numeric, the diagonal matrix \code{diag(jitter, nrow(M), ncol(M))} is added to matrix \eqn{M} to ensure the positive definiteness of \eqn{M}. If it is \code{TRUE}, then it is set as \code{1e-5} and the jitter is added. If it is \code{FALSE} (default), no jitter is added.}

\item{wishart}{Logical. If it is \code{TRUE}, the sample estimator from Wishart distribution \eqn{W_p(M/n, n)} and \eqn{W_p(U/n, n)} are generated as the output matrices \code{M} and \code{U}.}

\item{n}{The sample size. If \code{wishart} is \code{FALSE}, then \code{n} is ignored.}
}
\value{
\item{M}{The \eqn{p}-by-\eqn{p} matrix \code{M}.}
\item{U}{The \eqn{p}-by-\eqn{p} matrix \code{U}.}
\item{Gamma}{The \eqn{p}-by-\eqn{u} envelope basis.}
}
\description{
This function generates the matrices \eqn{M} and \eqn{U} with envelope structure.
}
\details{
The matrices \eqn{M} and \eqn{U} are in forms of
\deqn{M = \Gamma \Omega \Gamma^T + \Gamma_0\Omega_0\Gamma_0^T, U = \Gamma \Phi \Gamma^T.}

The envelope basis \eqn{\Gamma} is randomly generated from the Uniform (0, 1) distribution elementwise and then transformed to a semi-orthogonal matrix. \eqn{\Gamma_0} is the orthogonal completion of \eqn{\Gamma}.

In some cases, to guarantee that \eqn{M} is positive definite which is required by the definition of envelope, a \code{jitter} should be added to \eqn{M}.

If \code{wishart} is \code{TRUE}, after the matrices \eqn{M} and \eqn{U} are generated, the samples from Wishart distribution \eqn{W_p(M/n, n)} and \eqn{W_p(U/n, n)} are output as matrices \eqn{M} and \eqn{U}. If so, \code{n} is required.
}
\examples{
data1 <- MenvU_sim(p = 20, u = 5)
M1 <- data1$M
U1 <- data1$U

# Sample version from Wishart distribution
data2 <- MenvU_sim(p = 20, u = 5, wishart = TRUE, n = 200)
M2 <- data2$M
U2 <- data2$U

}
\references{
Cook, R.D. and Zhang, X., 2018. Fast envelope algorithms. Statistica Sinica, 28(3), pp.1179-1197.
}
