% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMZtester.API.R
\name{API4TMZ}
\alias{API4TMZ}
\title{Read multiple files exported from Thermec Master-Z tester}
\usage{
API4TMZ(Cdl, wd, ftype = ".csv", Straincln = 7, Stresscln = 8, startrow = 29)
}
\arguments{
\item{Cdl}{An handmade double list to determine selected conditions.}

\item{wd}{Work directory.}

\item{ftype}{File type to be read. Default value is ".csv".}

\item{Straincln}{An integer to specify column for Strain in your data. Default value
is 7 means the 7th column contains strain data, in the files exported from Thermec
Master-Z tester.}

\item{Stresscln}{An integer to specify column for Strain in your data. Default value
is 8 means the 8th column contains stress data, in the files exported from Thermec
Master-Z tester.}

\item{startrow}{An integer to ignore the prefix rows for testing conditions. Default
value is 29.}
}
\value{
A matrix-like summary table for all input files.
}
\description{
Read data from multiple files with structurized file names, then generate
a summary table. It will also be available for the files from other tester apparatus by
correct setting.
}
\examples{
variable1 <- c("factor11", "factor12", "factor13")
variable2 <- c("factor21", "factor22")
variable3 <- c("factor31", "factor32", "factor33", "factor34")
conditions <- list(variable1, variable2, variable3)

\dontrun{
SummaryTable <- API4TMZ(conditions, "/Your_Data_Directory/")
}
}
\keyword{APIfunction}
