% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OriginalFunctions.R
\name{ROC.semipar}
\alias{ROC.semipar}
\title{Semiparametric ROC Analysis}
\usage{
ROC.semipar(Z, S, phi, plot = TRUE)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}

\item{phi}{Percentage of patients taking viral load test.}

\item{plot}{Logical parameter indicating if ROC curve should be plotted. Default is \code{plot=TRUE}. If false, then only AUC is calculated.}
}
\value{
AUC The area under the ROC curve.
FNR Misdiagnoses rate for viral failure (false negative rate).
FPR Misdiagnoses rate for treatment failure (false positive rate).
}
\description{
This function performs ROC analysis on the rules from nonparametric approach. If \eqn{plot=TRUE}, the ROC curve is returned.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
a = ROC.semipar( Z, S, phi,plot=TRUE)
a$AUC
a$FNR
a$FPR
}
\keyword{AUC}
\keyword{semiparametric}
