% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{extractTFTG}
\alias{extractTFTG}
\title{extracts transcription factor (TF) and target gene (TG) information}
\usage{
extractTFTG(
  DEGs,
  catalog,
  TF.col = "TF..OFFICIAL_TF_CODING_GENE_NAME.",
  TG.col = "Target.gene..OFFICIAL_GENE_NAME."
)
}
\arguments{
\item{DEGs}{a character vector of DEGs (differentially expressed genes)}

\item{catalog}{a data frame of TFactS catalog (ver. 2)}

\item{TF.col}{the name of the column that contains the TF names}

\item{TG.col}{the name of the column that contains the TG names}
}
\value{
list
}
\description{
This function extracts information about transcription factor (TF) and
target gene (TG) with TFactS Catalogue (v2).
}
\examples{
data(DEGs)
data(catalog)

res <- extractTFTG(DEGs, catalog)
head(res$TFs)

}
\author{
Atsushi Fukushima
}
