% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{est_lambda}
\alias{est_lambda}
\title{Estimate the tuning parameter for a TFRE Lasso regression}
\usage{
est_lambda(X, alpha0 = 0.1, const_lambda = 1.01, times = 500)
}
\arguments{
\item{X}{Input matrix, of dimension n_obs x n_vars; each row is an observation vector.}

\item{alpha0}{The level to estimate the tuning parameter. Default value is 0.1.
See more details in "Details".}

\item{const_lambda}{The constant to estimate the tuning parameter, should be
greater than 1. Default value is 1.01. See more details in "Details".}

\item{times}{The size of simulated samples to estimate the tuning parameter.
Default value is 500.}
}
\value{
The estimated tuning parameter of the TFRE Lasso regression given X.
}
\description{
Estimate the tuning parameter of the TFRE Lasso regression given 
the covariate matrix X.
}
\details{
In TFRE Lasso regressions, the tuning parameter can be estimated independent
of errors. In Wang \emph{et al.} (2020), the following tuning parameter is suggested:
\deqn{\lambda^* = const\_lambda * G^{-1}_{||\bm{S}_n||_\infty}(1-alpha0)},
where \eqn{\bm{S}_n = -2[n(n-1)]^{-1}\sum_{j=1}^n\bm{x}_j[2r_j-(n+1)]}, \eqn{r_1,\ldots,r_n}
follows the uniform distribution on the per-mutations of the integers \eqn{\{1,\ldots,n\}},
and \eqn{G^{-1}_{||\bm{S}_n||_\infty}(1-alpha0)} denotes the \eqn{(1-alpha0)}-quantile
of the distribution of \eqn{||\bm{S}_n||_\infty}.
}
\examples{
n <- 20; p <- 50
X <- matrix(rnorm(n*p),n)
est_lambda(X)

}
\references{
Wang, L., Peng, B., Bradic, J., Li, R. and Wu, Y. (2020),
 \emph{A Tuning-free Robust and Efficient Approach to High-dimensional Regression,
 Journal of the American Statistical Association, 115:532, 1700-1714},
 \doi{10.1080/01621459.2020.1840989}.
}
\seealso{
\code{\link{TFRE}}
}
\author{
Yunan Wu and Lan Wang\cr Maintainer:
Yunan Wu <yunan.wu@utdallas.edu>
}
