% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaflowCalc.R
\name{SpWd_Area_calc}
\alias{SpWd_Area_calc}
\title{Sapwood area calculation}
\usage{
SpWd_Area_calc(diam, SpWd_frac = 1, HtWd_diam = 0)
}
\arguments{
\item{diam}{Vector with diameter.}

\item{SpWd_frac}{Numerical (from 0 to 1). Indicate the fraction of the diameter which is sapwood}

\item{HtWd_diam}{Vector with diameter of the heartwood.}
}
\value{
Return a numerical vector containing the sapwood area
}
\description{
Calculate sapwood area based on diameter, heartwood diameter and sapwood fraction
}
\details{
If SpWD_frac and HtWd_diam are both entered, the function will return an error. Units of "diam" and "HtWd_diam" should be the same.
}
\examples{
diam = c(12,14,16,13,15)
SpWd_Area_calc(diam=diam, SpWd_frac=0.2)
}
