% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readConfiguration.R
\name{readConfigurationsFile}
\alias{readConfigurationsFile}
\title{Read parameter configurations from a file}
\usage{
readConfigurationsFile(filename, parameters, debugLevel = 0L, text)
}
\arguments{
\item{filename}{\code{character(1)}\cr Filename from which the configurations should be read.
The contents should be readable by \code{read.table( , header=TRUE)}.}

\item{parameters}{\code{ParameterSpace}\cr Data structure containing the parameter
space definition. The data structure has to similar to the one returned by the
function \code{\link{readParameters}}.}

\item{debugLevel}{\code{integer(1)}\cr Larger values produce more verbose output.}

\item{text}{\code{character(1)}\cr If \code{file} is not supplied and this is,
then configurations are read from the value of \code{text} via a text connection.}
}
\value{
A data frame containing the obtained configurations.
Each row of the data frame is a candidate configuration,
the columns correspond to the parameter names in \code{parameters}.
}
\description{
Reads a set of target-algorithm configurations from a file and puts them in
\pkg{irace} format. The configurations are checked to match the parameters
description provided.
}
\details{
Example of an input file:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# This is a comment line
param_1    param_2
    0.5  "value_1"
    1.0         NA
    1.2  "value_3"
}\if{html}{\out{</div>}}

The order of the columns does not necessarily have to be the same
as in the file containing the definition of the parameters.
}
\seealso{
\code{\link[=readParameters]{readParameters()}} to obtain a valid parameter structure from a parameters file.
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
