% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{normalize_graph}
\alias{normalize_graph}
\title{Normalize Graph Node IDs}
\usage{
normalize_graph(graph_df)
}
\arguments{
\item{graph_df}{A data frame representing a graph with columns:
\code{from} and \code{to} (node IDs).}
}
\value{
A data frame with the same structure as \code{graph_df}, but with \code{from}
  and \code{to} columns remapped to consecutive integer IDs starting from 1.
  All other columns are preserved unchanged.
}
\description{
Normalize node IDs in a graph to be consecutive integers starting from 1.
  This is useful for ensuring compatibility with graph algorithms that require sequential node IDs.
}
\details{
This function:
\itemize{
  \item Extracts all unique node IDs from both \code{from} and \code{to} columns
  \item Sorts them in ascending order
  \item Remaps the original node IDs to sequential integers (1, 2, 3, ...)
  \item Updates both \code{from} and \code{to} columns with the normalized IDs
}

Normalization is useful when:
\itemize{
  \item Node IDs are non-consecutive (e.g., 1, 5, 10, 20)
  \item Node IDs are non-numeric or contain gaps
  \item Graph algorithms require sequential integer node IDs starting from 1
}

Note: This function only normalizes the node IDs; it does not modify the graph structure
or any other attributes. The mapping preserves the relative ordering of nodes.
}
\examples{
library(flownet)

# Create graph with non-consecutive node IDs
graph <- data.frame(
  from = c(10, 20, 20),
  to = c(20, 30, 40),
  cost = c(1, 2, 3)
)

# Normalize to consecutive integers (1, 2, 3, 4)
graph_norm <- normalize_graph(graph)
graph_norm

}
\seealso{
\link{nodes_from_graph} \link{flownet-package}
}
