% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp-api.R
\name{sp_tooltip}
\alias{sp_tooltip}
\title{Create a tooltip for SveltePlots charts}
\usage{
sp_tooltip(
  sp,
  type = NULL,
  format = NULL,
  background_color = "white",
  opacity = 0.8,
  text_color = "black",
  border_color = NULL,
  border_width = 1,
  font_size = 12,
  font_family = "Arial, sans-serif",
  padding = 5,
  position = NULL,
  show_delay = 0,
  animation = FALSE,
  animation_params = NULL,
  justify_content = "space-between",
  cross_hair = FALSE
)
}
\arguments{
\item{sp}{The SveltePlots object to attach the tooltip to.}

\item{type}{The type of tooltip, "shared" or "single". Default depends on the x-axis and is shared for date and factors and single for numeric.}

\item{format}{The format of tooltip content.}

\item{background_color}{Background color of the tooltip (default: "white").}

\item{opacity}{Numeric value between 0 and 1 specifying the opacity of the tooltip (default: 0.8).}

\item{text_color}{Text color of the tooltip (default: "black").}

\item{border_color}{Border color of the tooltip (default: "#cccccc").}

\item{border_width}{Border width of the tooltip (default: 1).}

\item{font_size}{Font size of the tooltip text (default: 12).}

\item{font_family}{Font family of the tooltip text (default: "Arial, sans-serif").}

\item{padding}{Padding around the tooltip content (default: 5).}

\item{position}{Position of the tooltip relative to the data point ("top", "bottom", "left", "right").}

\item{show_delay}{Delay in milliseconds before showing the tooltip (default: 0).}

\item{animation}{Whether to animate the tooltip (default: FALSE).}

\item{animation_params}{A list containing animation parameters for multiple series when type = "shared":
\describe{
  \item{duration}{The duration of the animation in milliseconds. Default is 0.}
  \item{delay}{The delay before the animation starts in milliseconds. Default is 0.}
}}

\item{justify_content}{How to justify the content inside the tooltip (default: "space-between").}

\item{cross_hair}{Whether to enable crosshair (default: FALSE).}
}
\value{
A SveltePlots object with an attached tooltip.
}
\description{
This function creates a customizable tooltip for SveltePlots charts.
Tooltips provide additional information when hovering over data points.
}
