% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMC_FCS_MI_Compt.R
\name{new.smcfcs.compt}
\alias{new.smcfcs.compt}
\title{Multiple imputation method for missing covariates in competing risks endpoint.}
\usage{
new.smcfcs.compt(data, smformula, method, m = 10, rjlimit = 5000)
}
\arguments{
\item{data}{The input data with missing values. Note: all missing values should be coded as \code{"NA"}, all binary covariates should be
coded as 0/1, and all categorical covariates with more than two categories should have a class of \code{"factor"}.}

\item{smformula}{The substantive model formula. For competing risks data, this should be a list of two Cox models for both the event of interest and the competing event (see example).}

\item{method}{A vector of strings for each covariate specifying the the type of regression model to impute them. The length of this vector should match the number of columns in the
input dataset, and also match the position of each column (Including the outcomes).  If a covariate is fully observed, the value should be blank (""). Other possible options are
\code{"norm"}(linear regression for continuous covariates), \code{"lm"}(logistic regression for binary covariates), and \code{"mlogit"}(multinomial logistic regression
for categorical covariates).}

\item{m}{Number of complete datasets to generate, default is 10.}

\item{rjlimit}{Maximum number of rejection sampling attempts, default is 5000. If there are
subjects who did not get a success sampled value for the missing after reaching the limit,
a warning message will be issued suggesting to increase the limit.}
}
\value{
A list containing the imputed datasets.
}
\description{
Generates multiple imputed datasets from a substantive model compatible fully conditional
specification model. This method incorporates the cause-specific hazards regression model into the imputation stage, and
assumes that the censoring process also depends on the covariates with missing values. Without loss of generality, we assumed
there is only one competing event. Our method is an extension of Bartlett et. al. (2015) and Bartlett and Taylor (2016).
}
\examples{
\donttest{
# Generate data with missing values
compt <- generate.compt(n = 500, beta1 = c(1,1,-1), beta2 = c(2, 2, -2),
phi= c(-1,-1,-0.5), gamma = c(1,1,1,-1), seed = 112358)
# Impute
imputed <- new.smcfcs.compt(data = compt,
smformula = c("Surv(time, delta==1)~X1 +X2+X3", "Surv(time, delta==2)~X1 +X2+X3"),
method = c("","", "norm","logreg",""),m = 10, rjlimit = 10000)
# Fit a Cox regression on each imputed dataset, then produce the final estimates using Rubin's rule.
require(mitools)
library(survival)
imputed.fit <- with(imputationList(imputed), expr = coxph(Surv(time, delta==1) ~ X1+X2+X3))
summary(MIcombine(imputed.fit))}
#' @author Qinghua Lian \email{qlian@mcw.edu}
}
\references{
Bartlett JW, Taylor JM. (2016) Missing covariates in competing risks analysis. \emph{Biostatistics}. \strong{17(4)}, 751-63.
}
\author{
Qinghua Lian \email{qlian@mcw.edu}
}
